/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.data.recipe.ConditionalRecipeSerializer;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1863.class})
public class RecipeManagerMixin {
    @Final
    @Shadow
    private class_7225.class_7874 field_48848;

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void apply(Map<class_2960, JsonElement> recipes, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        HashSet<class_2960> removed = null;
        for (Map.Entry<class_2960, JsonElement> entry : recipes.entrySet()) {
            String type;
            if (entry.getValue() == null || !entry.getValue().isJsonObject()) continue;
            class_2960 identifier = entry.getKey();
            JsonObject json = entry.getValue().getAsJsonObject();
            if (json == null || !json.has("type") || !json.get("type").isJsonPrimitive() || !json.getAsJsonPrimitive("type").isString() || !RegistryUtil.isValidIdentifier(type = json.get("type").getAsString()) || !class_2960.method_60654((String)type).equals((Object)Registries.RECIPE_SERIALIZERS.getIdentifier(ConditionalRecipeSerializer.INSTANCE))) continue;
            JsonElement recipeJson = ConditionalRecipeSerializer.unwrapRecipe(identifier, json);
            if (recipeJson == null) {
                if (removed == null) {
                    removed = new HashSet<class_2960>();
                }
                removed.add(identifier);
                continue;
            }
            recipes.put(identifier, recipeJson);
        }
        if (removed != null) {
            removed.forEach(recipes::remove);
        }
    }

    @Inject(method={"fromJson(Lnet/minecraft/resources/ResourceLocation;Lcom/google/gson/JsonObject;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/crafting/RecipeHolder;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void fromJson(class_2960 recipeLocation, JsonObject json, class_7225.class_7874 provider, CallbackInfoReturnable<class_8786<?>> ci) {
        String type;
        if (json != null && json.has("type") && json.get("type").isJsonPrimitive() && json.getAsJsonPrimitive("type").isString() && RegistryUtil.isValidIdentifier(type = json.get("type").getAsString()) && class_2960.method_60654((String)type).equals((Object)Registries.RECIPE_SERIALIZERS.getIdentifier(ConditionalRecipeSerializer.INSTANCE))) {
            JsonElement recipeJson = ConditionalRecipeSerializer.unwrapRecipe(recipeLocation, json);
            if (recipeJson == null) {
                ci.setReturnValue((Object)new class_8786(recipeLocation, ConditionalRecipeSerializer.DUMMY_RECIPE));
            } else {
                ci.setReturnValue((Object)class_1863.method_17720((class_2960)recipeLocation, (JsonObject)json.getAsJsonObject("recipe"), (class_7225.class_7874)provider));
            }
        }
    }
}

